dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 3, 280, 220, "assets/images/table/ballroom", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 8, 220, 360, "assets/images/table/ballroom_8", "assets/images/food/item_mark2", "B" );


useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 1;
numServers = 1;
maxCoupleHappiness = 200;

-- Group 1
guest = LManager.GenGuest(female01);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female04;
guest.percentRequestCoffee = 40;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 6, 3000);


-- Group 2


guest = LManager.GenGuest(uncle);
guest.matchType = female04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(7, 7, 25000);

-- Group 3

guest = LManager.GenGuest(male01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(8, 10, 55000);

-- Group 4

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 13, 90000);

-- Group 5

guest = LManager.GenGuest(aunt);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 15, 110000);


-- Group 6

guest = LManager.GenGuest(male04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = male04;
guest.percentRequestCoffee = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 20, 140000);



LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("speakerDelay", 120000); 
LManager:SetLevelSetting ("speakerChance", 40);

LManager:SetLevelSetting ("bridesmaidsDelay", 96000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

LManager:SetLevelSetting ("blaster", 1);

-- Set up the Level Settings
LManager:SetLevelNumber(2,7);
LManager:SetLevelScores(7500, 11000);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/new_dance_3.ogg","assets/audio/music/uptempo_3.ogg");
LManager:SetBackgroundImage("assets/images/bg_ballroom");
LManager:SetChairImage("assets/images/table/chair02");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );